unit xFont;

(*******************************************************************)
(** //                    XENGINE Font Unit                    // **)
(** //  (C) 2025-2026 Coded by Adam Kozinski & Dominik Galoch  // **)
(** ///////////////////////////////////////////////////////////// **)
(*******************************************************************)

interface

uses xvga256;

const
    NUM_CHARS = 93;
    
type
    TChar = array[0..7] of byte;

var
    FONT_DATA : array[0..NUM_CHARS] of TChar;

const
    DEFAULT_FONT : array[0..NUM_CHARS] of TChar = (
        ($00, $00, $00, $00, $00, $08, $00, $00),  {0} {'.'}
        ($18, $24, $24, $24, $24, $18, $00, $00),  {1} {'0'}
        ($18, $28, $08, $08, $08, $3C, $00, $00),  {2} {'1'}
        ($38, $44, $08, $10, $20, $7C, $00, $00),  {3} {'2'}
        ($38, $44, $04, $18, $44, $38, $00, $00),  {4} {'3'}
        ($20, $20, $24, $3E, $04, $04, $00, $00),  {5} {'4'}
        ($3E, $20, $3C, $02, $02, $3C, $00, $00),  {6} {'5'}
        ($1C, $20, $38, $24, $24, $18, $00, $00),  {7} {'6'}
        ($3C, $44, $08, $10, $10, $10, $00, $00),  {8} {'7'}
        ($18, $24, $18, $24, $24, $18, $00, $00),  {9} {'8'}
        ($18, $24, $1C, $04, $04, $18, $00, $00),  {10} {'9'}
        ($18, $24, $24, $7E, $42, $42, $00, $00),  {11} {'A'}
        ($7C, $22, $3C, $22, $22, $7C, $00, $00),  {12} {'B'}
        ($3C, $42, $40, $40, $42, $3C, $00, $00),  {13} {'C'}
        ($7C, $22, $22, $22, $22, $7C, $00, $00),  {14} {'D'}
        ($7E, $22, $38, $20, $22, $7E, $00, $00),  {15} {'E'}
        ($7E, $22, $38, $20, $20, $70, $00, $00),  {16} {'F'}
        ($1C, $22, $20, $26, $22, $1C, $00, $00),  {17} {'G'}
        ($44, $44, $7C, $44, $44, $44, $00, $00),  {18} {'H'}
        ($38, $10, $10, $10, $10, $38, $00, $00),  {19} {'I'}
        ($70, $10, $10, $90, $90, $70, $00, $00),  {20} {'J'}
        ($64, $28, $30, $28, $24, $64, $00, $00),  {21} {'K'}
        ($38, $10, $10, $10, $12, $1E, $00, $00),  {22} {'L'}
        ($22, $36, $2A, $22, $22, $22, $00, $00),  {23} {'M'}
        ($22, $32, $2A, $26, $22, $22, $00, $00),  {24} {'N'}
        ($38, $44, $44, $44, $44, $38, $00, $00),  {25} {'O'}
        ($7C, $22, $3C, $20, $20, $70, $00, $00),  {26} {'P'}
        ($38, $44, $44, $44, $4C, $38, $08, $04),  {27} {'Q'}
        ($7C, $22, $3C, $22, $22, $62, $00, $00),  {28} {'R'}
        ($18, $24, $10, $08, $24, $18, $00, $00),  {29} {'S'}
        ($7F, $49, $08, $08, $08, $1C, $00, $00),  {30} {'T'}
        ($22, $22, $22, $22, $22, $1C, $00, $00),  {31} {'U'}
        ($22, $22, $22, $22, $14, $08, $00, $00),  {32} {'V'}
        ($22, $22, $22, $2A, $36, $22, $00, $00),  {33} {'W'}
        ($22, $14, $08, $14, $22, $22, $00, $00),  {34} {'X'}
        ($22, $22, $14, $08, $08, $1C, $00, $00),  {35} {'Y'}
        ($3E, $22, $04, $08, $12, $3E, $00, $00),  {36} {'Z'}
        ($00, $00, $38, $44, $44, $3E, $00, $00),  {37} {'a'}
        ($20, $20, $3C, $22, $22, $3C, $00, $00),  {38} {'b'}
        ($00, $00, $1C, $20, $20, $1C, $00, $00),  {39} {'c'}
        ($02, $02, $1E, $22, $22, $1E, $00, $00),  {40} {'d'}
        ($00, $1C, $22, $3E, $20, $1C, $00, $00),  {41} {'e'}
        ($18, $24, $20, $70, $20, $20, $00, $00),  {42} {'f'}
        ($00, $00, $1C, $22, $22, $1E, $02, $1C),  {43} {'g'}
        ($20, $20, $3C, $22, $22, $22, $00, $00),  {44} {'h'}
        ($00, $10, $00, $10, $10, $10, $00, $00),  {45} {'i'}
        ($00, $10, $00, $10, $10, $10, $10, $70),  {46} {'j'}
        ($20, $20, $24, $38, $24, $24, $00, $00),  {47} {'k'}
        ($20, $20, $20, $20, $20, $38, $00, $00),  {48} {'l'}
        ($00, $00, $63, $55, $49, $41, $00, $00),  {49} {'m'}
        ($00, $00, $2E, $11, $11, $11, $00, $00),  {50} {'n'}
        ($00, $00, $1C, $22, $22, $1C, $00, $00),  {51} {'o'}
        ($00, $00, $3C, $22, $22, $3C, $20, $20),  {52} {'p'}
        ($00, $00, $1E, $22, $22, $1E, $02, $02),  {53} {'q'}
        ($00, $00, $2C, $12, $10, $10, $00, $00),  {54} {'r'}
        ($00, $3C, $22, $18, $44, $38, $00, $00),  {55} {'s'}
        ($10, $10, $38, $10, $10, $10, $00, $00),  {56} {'t'}
        ($00, $00, $24, $24, $24, $18, $00, $00),  {57} {'u'}
        ($00, $00, $14, $14, $14, $08, $00, $00),  {58} {'v'}
        ($00, $00, $41, $49, $55, $63, $00, $00),  {59} {'w'}
        ($00, $00, $24, $18, $18, $24, $00, $00),  {60} {'x'}
        ($00, $00, $24, $24, $24, $3C, $04, $3C),  {61} {'y'}
        ($00, $00, $3C, $08, $10, $3C, $00, $00),  {62} {'z'}
        ($00, $00, $00, $3C, $00, $00, $00, $00),  {63} {'-'}
        ($00, $00, $10, $38, $10, $00, $00, $00),  {64} {'+'}
        ($00, $00, $00, $00, $00, $10, $10, $20),  {65} {','}
        ($00, $02, $04, $08, $10, $20, $00, $00),  {66} {'/'}
        ($00, $14, $08, $14, $00, $00, $00, $00),  {67} {'*'}
        ($00, $00, $08, $00, $00, $08, $00, $00),  {68} {':'}
        ($00, $00, $3C, $00, $3C, $00, $00, $00),  {69} {'='}
        ($00, $00, $00, $00, $00, $7E, $00, $00),  {70} {'_'}
        ($10, $10, $10, $10, $10, $00, $10, $00),  {71} {'!'}
        ($38, $44, $54, $58, $40, $3C, $00, $00),  {72} {'@'}
        ($14, $14, $7C, $14, $14, $00, $00, $00),  {73} {'#'}
        ($08, $3C, $40, $38, $04, $78, $00, $00),  {74} {'$'}
        ($42, $44, $08, $10, $22, $42, $00, $00),  {75} {'%'}
        ($18, $24, $42, $00, $00, $00, $00, $00),  {76} {'^'}
        ($18, $24, $10, $24, $24, $1A, $00, $00),  {77} {'&'}
        ($08, $14, $08, $14, $00, $00, $00, $00),  {78} {'('}
        ($20, $10, $08, $10, $20, $00, $00, $00),  {79} {')'}
        ($0C, $10, $30, $30, $10, $0C, $00, $00),  {80} (*{*)
        ($30, $08, $0C, $0C, $08, $30, $00, $00),  {81} (*}*)
        ($3C, $20, $20, $20, $20, $3C, $00, $00),  {82} {'['}
        ($3C, $04, $04, $04, $04, $3C, $00, $00),  {83} {']'}
        ($00, $10, $00, $10, $10, $20, $00, $00),  {84} {';'}
        ($08, $08, $10, $00, $00, $00, $00, $00),  {85} {'''}
        ($24, $24, $00, $00, $00, $00, $00, $00),  {86} {'"'}
        ($04, $08, $10, $20, $10, $08, $04, $00),  {87} {'<'}
        ($20, $10, $08, $04, $08, $10, $20, $00),  {88} {'>'}
        ($18, $24, $04, $08, $00, $08, $00, $00),  {89} {'?'}
        ($20, $10, $08, $04, $02, $00, $00, $00),  {90} {'\'}
        ($10, $10, $10, $10, $10, $10, $00, $00),  {91} {'|'}
        ($20, $10, $00, $00, $00, $00, $00, $00),  {92} {'`'}
        ($36, $48, $00, $00, $00, $00, $00, $00)   {93} {'~'}
    );

{====================================================================}
{          HEADERS OF PROCEDURES AND FUNCTIONS                       }
{====================================================================}

procedure xLoadFont(filename : string);                                             { Load font from file }
procedure xLoadFontPkg(package_name, internal_name : string);                       { Load font from package }
procedure xText(buffer_ptr : pointer; x, y : word; text : string; color : byte);    { Draw text on screen }
procedure xInitFont;                                                                { Initialize font (load default font) }

implementation

(***********************************************************)

procedure xLoadFont(filename : string);
var
    image : TImage;
    chars_per_row, idx, col, row, x, y : word;
    pixel, byte_val : byte;
begin
    xLoadBitmap(image, filename);
    if (image.width mod 8 <> 0) or (image.height mod 8 <> 0) then
    begin
        xFreeImage(image);
        exit;
    end;
    chars_per_row := image.width div 8;
    for idx := 0 to NUM_CHARS do
    begin
        col := idx mod chars_per_row;
        row := idx div chars_per_row;
        if (row * 8 >= image.height) then break;
        for y := 0 to 7 do
        begin
            byte_val := 0;
            for x := 0 to 7 do
            begin
                pixel := image.img_ptr^[(row*8 + y) * image.width + (col*8 + x)];
                if pixel <> 0 then
                    byte_val := byte_val or (1 shl (7 - x));
            end;
            FONT_DATA[idx][y] := byte_val;
        end;
    end;
    xFreeImage(image);
end;

(***********************************************************)

procedure xLoadFontPkg(package_name, internal_name : string);
var
    image : TImage;
    chars_per_row, idx, col, row, x, y : word;
    pixel, byte_val : byte;
begin
    xLoadBitmapPkg(package_name, internal_name, image);
    if (image.width mod 8 <> 0) or (image.height mod 8 <> 0) then
    begin
        xFreeImage(image);
        exit;
    end;
    chars_per_row := image.width div 8;
    for idx := 0 to NUM_CHARS do
    begin
        col := idx mod chars_per_row;
        row := idx div chars_per_row;
        if (row * 8 >= image.height) then break;
        for y := 0 to 7 do
        begin
            byte_val := 0;
            for x := 0 to 7 do
            begin
                pixel := image.img_ptr^[(row*8 + y) * image.width + (col*8 + x)];
                if pixel <> 0 then
                    byte_val := byte_val or (1 shl (7 - x));
            end;
            FONT_DATA[idx][y] := byte_val;
        end;
    end;
    xFreeImage(image);
end;

(***********************************************************)

procedure xText(buffer_ptr : pointer; x, y : word; text : string; color : byte);
var
    char_nr : byte;
    char_counter, bit_counter : byte;
    byte_counter : byte;
    idx : byte;
    ofs : word;
    mask : byte;
begin
    if (y + 8 > SCREEN_HEIGHT - 1) then exit;

    ofs := (y * SCREEN_WIDTH) + x;
    char_nr := Length(text);

    for char_counter := 1 to char_nr do
    begin
        case text[char_counter] of
            ' ': begin
                     x := x + 8;
                     if x > 312 then break;
                     ofs := (y * SCREEN_WIDTH) + x;
                     continue;
                 end;
            '0'..'9': idx := ord(text[char_counter]) - 47;
            'A'..'Z': idx := ord(text[char_counter]) - 54;
            'a'..'z': idx := ord(text[char_counter]) - 60;
            '.': idx := 0;
            '-': idx := 63;
            '+': idx := 64;
            ',': idx := 65;
            '/': idx := 66;
            '*': idx := 67;
            ':': idx := 68;
            '=': idx := 69;
            '_': idx := 70;
            '!': idx := 71;
            '@': idx := 72;
            '#': idx := 73;
            '$': idx := 74;
            '%': idx := 75;
            '^': idx := 76;
            '&': idx := 77;
            '(': idx := 78;
            ')': idx := 79;
            '{': idx := 80;
            '}': idx := 81;
            '[': idx := 82;
            ']': idx := 83;
            ';': idx := 84;
            '''': idx := 85;
            '"': idx := 86;
            '<': idx := 87;
            '>': idx := 88;
            '?': idx := 89;
            '\': idx := 90;
            '|': idx := 91;
            '`': idx := 92;
            '~': idx := 93;
            else begin
                     x := x + 8;
                     if x > 312 then break;
                     ofs := (y * SCREEN_WIDTH) + x;
                     continue;
                 end;
        end;

        mask := $80;

        for byte_counter := 0 to 7 do
        begin
            for bit_counter := 0 to 7 do
            begin
                if (FONT_DATA[idx][byte_counter] and mask <> 0) then
                    asm
                        les di, buffer_ptr
                        add di, ofs
                        mov ah, color
                        mov byte ptr es:[di], ah
                    end;
                mask := mask shr 1;
                ofs := ofs + 1;
            end;
            ofs := ofs + (SCREEN_WIDTH - 8);
            mask := $80;
        end;

        x := x + 8;
        if x > 312 then break;
        ofs := (y * SCREEN_WIDTH) + x;
    end;
end;

(***********************************************************)

procedure xInitFont;
var
    i : integer;
begin
    for i := 0 to NUM_CHARS do
        FONT_DATA[i] := DEFAULT_FONT[i];
end;

(***********************************************************)

begin
    xInitFont;
end.